/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators;

import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmCustomDataValidator;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.ValidationException;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.Validator;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ps.wcl.core.form.WDateChooser;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Properties;

public class StrictDateValidator
extends Validator
implements PmCustomDataValidator {
    private static final String TRACE_MASKT = "XPMNVDST";
    private static final String TRACE_MASKF = "XPMNVDSF";
    private Properties properties;

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void validate(Object value) throws ValidationException {
        if (value != null) {
            if (this.component instanceof WDateChooser) {
                WDateChooser wdc = (WDateChooser)this.component;
                String rString = wdc.getText();
                Trace.trace(TRACE_MASKF, "StrictDateValidator validating raw string: '" + rString + "'");
                DateFormat format = wdc.getDateFormat(this.triggerContext.getLocale());
                format.setLenient(false);
                ParsePosition pp = new ParsePosition(0);
                Date date = format.parse(rString, pp);
                if (date == null || pp.getIndex() != rString.length()) {
                    Trace.trace(TRACE_MASKF, "StrictDateValidator throwing validation exception (didn't parse correctly)");
                    throw new ValidationException(new MessageText("com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.res.validator", "StrictDateParseFailure"));
                }
            } else {
                Trace.trace(TRACE_MASKF, "StrictDateValidator being asked to validate but given non WDateChooser?");
            }
        } else {
            Trace.trace(TRACE_MASKF, "StrictDateValidator.validate(" + value + ") accepted (null)");
        }
    }
}

